

<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="row">
        <div class="col-md-3">
            <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        </div>
        <div class="col-md-9">
            <!-- Main content area -->
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span><?php echo e(__('User List')); ?></span>
                    <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#createUserModal">
                        <i class="fas fa-user-plus me-2"></i> Create User
                    </button>
                </div>

                <div class="card-body">
                    <!-- Display user list -->
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($user->name); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td>
                                    <!-- View User Button -->
                                    <a href="<?php echo e(route('users.show', $user->id)); ?>" class="btn btn-sm btn-primary" title="View User">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    
                                    <!-- Edit User Button -->
                                    <button type="button" class="btn btn-sm btn-success edit-user-btn" data-user-id="<?php echo e($user->id); ?>" data-toggle="modal" data-target="#editUserModal<?php echo e($user->id); ?>" title="Edit User">
                                        <i class="fas fa-edit"></i>
                                    </button>
                                    
                                    <!-- Delete User Form -->
                                    <?php if($user->id !== 1): ?> <!-- Assuming ID 1 is not deletable -->
                                    <form id="delete-form-<?php echo e($user->id); ?>" action="<?php echo e(route('users.destroy', $user->id)); ?>" method="POST" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="button" class="btn btn-sm btn-danger delete-user-btn" data-user-id="<?php echo e($user->id); ?>" title="Delete User">
                                            <i class="fas fa-trash-alt"></i>
                                        </button>
                                    </form>
                                    <?php else: ?>
                                    <span class="text-muted">Not Deletable</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Modal -->
<div class="modal fade" id="createUserModal" tabindex="-1" role="dialog" aria-labelledby="createUserModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createUserModalLabel">Create User</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('users.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-body">
                    <!-- Add your form fields here -->
                    <div class="form-group">
                        <label for="name">Name</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control" id="email" name="email" required>
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" class="form-control" id="password" name="password" required>
                    </div>
                    <div class="form-group">
                        <label for="password_confirmation">Confirm Password</label>
                        <input type="password" class="form-control" id="password_confirmation" name="password_confirmation" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Create</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<!-- Edit User Modal for each user -->
<div class="modal fade" id="editUserModal<?php echo e($user->id); ?>" tabindex="-1" role="dialog" aria-labelledby="editUserModalLabel<?php echo e($user->id); ?>" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editUserModalLabel<?php echo e($user->id); ?>">Edit User</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <form action="<?php echo e(route('users.update', $user->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <div class="modal-body">
                    <!-- Edit user form fields -->
                    <div class="form-group">
                        <label for="edit_name<?php echo e($user->id); ?>">Name</label>
                        <input type="text" class="form-control" id="edit_name<?php echo e($user->id); ?>" name="name" value="<?php echo e($user->name); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="edit_email<?php echo e($user->id); ?>">Email</label>
                        <input type="email" class="form-control" id="edit_email<?php echo e($user->id); ?>" name="email" value="<?php echo e($user->email); ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="edit_password<?php echo e($user->id); ?>">New Password</label>
                        <input type="password" class="form-control" id="edit_password<?php echo e($user->id); ?>" name="password" placeholder="Leave blank to keep current password">
                    </div>
                    <div class="form-group">
                        <label for="edit_password_confirmation<?php echo e($user->id); ?>">Confirm New Password</label>
                        <input type="password" class="form-control" id="edit_password_confirmation<?php echo e($user->id); ?>" name="password_confirmation" placeholder="Confirm new password">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php $__env->stopSection(); ?>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteButtons = document.querySelectorAll('.delete-user-btn');

        deleteButtons.forEach(button => {
            button.addEventListener('click', function () {
                const userId = this.getAttribute('data-user-id');

                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You won\'t be able to revert this!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        document.getElementById('delete-form-' + userId).submit();
                    }
                });
            });
        });
    });
</script>
<!-- JavaScript -->
<script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.2/dist/umd/popper.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Projects 2024\Movie Download\Laravel\Laravel V1.0\resources\views/users/index.blade.php ENDPATH**/ ?>