<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Download Links</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        /* Your custom CSS styles here */
        body {
            padding: 20px;
        }

        .image-preview {
            width: 60px;
            height: auto;
            object-fit: cover;
            border-radius: 8px;
            box-shadow: 0 0 5px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>

<body class="bg-gray-100">
    <div class="container mx-auto">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3">
                <?php echo $__env->make('layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
            </div>

            <!-- Main Content -->
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header flex justify-between items-center">
                        <span>Download Links</span>
                        <a href="<?php echo e(route('download-links.create')); ?>" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Create Download Link
                        </a>
                    </div>
                    <div class="card-body">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Title</th>
                                    <th>Type</th>
                                    <th>Description</th>
                                    <th>Image</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $downloadLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $downloadLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($downloadLink->title); ?></td>
                                    <td><?php echo e($downloadLink->type); ?></td>
                                    <td><?php echo e(strlen($downloadLink->description) > 25 ? substr($downloadLink->description, 0, 25) . '...' : $downloadLink->description); ?></td>
                                    <td>
                                        <?php if($downloadLink->image): ?>
                                        <img src="<?php echo e(asset('storage/' . $downloadLink->image)); ?>"
                                            alt="<?php echo e($downloadLink->title); ?>" class="image-preview">
                                        <?php else: ?>
                                        No Image
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <!-- Button trigger modal -->
                                        <button type="button" class="btn btn-sm btn-outline-primary me-2" data-bs-toggle="modal"
                                            data-bs-target="#downloadLinkModal<?php echo e($downloadLink->id); ?>">
                                            <i class="bi bi-info-circle"></i> Show
                                        </button>
                                        
                                        <form id="deleteForm<?php echo e($downloadLink->id); ?>" action="<?php echo e(route('download-links.destroy', $downloadLink->id)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="button" class="btn btn-sm btn-outline-danger delete-link"
                                                    data-id="<?php echo e($downloadLink->id); ?>">
                                                <i class="bi bi-trash"></i> Delete
                                            </button>
                                        </form>
                                        
                                        <!-- Additional Button for Adding Links -->
                                        <button type="button" class="btn btn-sm btn-outline-success" data-bs-toggle="modal"
                                            data-bs-target="#addLinkModal<?php echo e($downloadLink->id); ?>">
                                            <i class="bi bi-plus"></i> Add Link
                                        </button>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="5" class="text-center">No download links found.</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                        
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php $__currentLoopData = $downloadLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $downloadLink): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="modal fade" id="downloadLinkModal<?php echo e($downloadLink->id); ?>" tabindex="-1"
        aria-labelledby="downloadLinkModalLabel<?php echo e($downloadLink->id); ?>" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title text-center" id="downloadLinkModalLabel<?php echo e($downloadLink->id); ?>"><?php echo e($downloadLink->title); ?> Details</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="text-center mb-4 mt-4">
                        <h5 class="card-title"><strong><?php echo e($downloadLink->title); ?></strong></h5>
                        <hr class="text-center mb-4 mt-4">
                        <div class="d-flex justify-content-center mb-4 mt-4">
                            <?php if($downloadLink->image): ?>
                        <img src="<?php echo e(asset('storage/' . $downloadLink->image)); ?>" alt="<?php echo e($downloadLink->title); ?>" class="img-fluid rounded shadow-lg"  style="width: 300px; height: 150px; object-fit: cover;">
                        <?php else: ?>
                        <img src="placeholder.jpg" alt="Placeholder" class="img-fluid rounded-circle mb-3 shadow-lg"
                            style="width: 150px; height: 150px; object-fit: cover;">
                        <?php endif; ?>
                        </div>
                        <p><strong>Description:</strong> <?php echo e($downloadLink->description); ?></p>

                    </div>
    
                    <div class="row justify-content-center">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead class="bg-light">
                                        <tr>
                                            <th>Type</th>
                                            <th>Link Type</th>
                                            <th>URL</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $downloadLink->types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $__currentLoopData = $type->links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <?php if($index === 0): ?>
                                            <td rowspan="<?php echo e(count($type->links)); ?>"><?php echo e($type->type); ?></td>
                                            <?php endif; ?>
                                            <td><?php echo e($link->link_type); ?></td>
                                            <td><?php echo e($link->url); ?></td>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
    
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    
    

    <!-- Modal for Add Link -->
    <div class="modal fade" id="addLinkModal<?php echo e($downloadLink->id); ?>" tabindex="-1"
        aria-labelledby="addLinkModalLabel<?php echo e($downloadLink->id); ?>" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addLinkModalLabel<?php echo e($downloadLink->id); ?>">Add Link for <?php echo e($downloadLink->title); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form action="<?php echo e(route('download-links.storeLink', ['id' => $downloadLink->id])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="linkType" class="form-label">Link Type</label>
                            <select class="form-select" id="linkType" name="link_type" required>
                                <option value="">Select Type</option>
                                <?php $__currentLoopData = $downloadLink->types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type->type); ?>"><?php echo e($type->type); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="mb-3">
                            <label for="linkTypeInput" class="form-label">Link Type (Input)</label>
                            <input type="text" class="form-control" id="linkTypeInput" name="link_type_input" required>
                            <small id="linkTypeInputHelp" class="form-text text-muted">Enter additional link type if not in the list.</small>
                        </div>

                        <div class="mb-3">
                            <label for="url" class="form-label">URL</label>
                            <input type="text" class="form-control" id="url" name="url" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Add Link</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Select all delete buttons with class delete-link
        const deleteButtons = document.querySelectorAll('.delete-link');

        deleteButtons.forEach(button => {
            button.addEventListener('click', function (event) {
                const downloadLinkId = this.getAttribute('data-id');

                // Display SweetAlert confirmation
                Swal.fire({
                    title: 'Are you sure?',
                    text: 'You will not be able to recover this download link!',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Yes, delete it!'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // If confirmed, submit the form
                        document.getElementById(`deleteForm${downloadLinkId}`).submit();
                    }
                });
            });
        });
    });
</script>

</html>
<?php /**PATH E:\Projects 2024\Movie Download\Laravel\Laravel V1.0\resources\views/download-links/index.blade.php ENDPATH**/ ?>